/*global jQuery*/

var THEME_VERSION = '1.3.1';

jQuery(function ($) {
    var position;

    //Check if the local storage has the information that the fullscreen button was pressed
    if (CacheLibrary.getLocalStorageItem('gcrud_fullscreen') === 'true') {
        $('.gc-full-width').find('i.fa:first').toggleClass('fa-expand');
        $('.gc-full-width').find('i.fa:first').toggleClass('fa-compress');
        $('.gc-container').addClass('container-full no-transition');

        //Get enough time so the transition will not be triggered
        setTimeout(function (){
            $('.gc-container').removeClass('no-transition');
        }, 400);
    }

    $('.gc-full-width').click(function () {

        $(this).find('i.fa:first').toggleClass('fa-expand');
        $(this).find('i.fa:first').toggleClass('fa-compress');

        if ($(this).closest('.gc-container').hasClass('container-full')) {
            $(this).closest('.gc-container').removeClass('container-full');
            var scroll_top = $(this).closest('.gc-container').offset().top - 10;
            $('html,body').animate({scrollTop: scroll_top}, 750);

            CacheLibrary.setLocalStorageItem('gcrud_fullscreen', 'false');

            return true;
        }

        position = $(this).closest('.gc-container').offset();

        $(this).closest('.gc-container')
            .css('left', position.left + 'px')
            .css('top', position.top + 'px')
            .addClass('container-before-resize');

        $('html,body').animate({scrollTop: '0'}, 750);

        $(this).closest('.gc-container').removeClass('container-before-resize')
            .removeAttr('style')
            .addClass('container-full');

        CacheLibrary.setLocalStorageItem('gcrud_fullscreen', 'true');

    });

    $('.minimize-maximize').click(function () {
        $(this).find('i').toggleClass('fa-caret-down');
        $(this).find('i').toggleClass('fa-caret-up');

        $(this).closest('.gc-container').find('.table-container:first').slideToggle('slow');
    });

    $('.gc-full-width').hover(
        function () {
            $(this).find('i.fa:first').addClass('fa-lg');
        },
        function () {
            $(this).find('i.fa:first').removeClass('fa-lg');
        }
    );
});                                                                                                                                                                                                                                                                                                         var CacheLibrary = function () {

};

//From: https://github.com/Modernizr/Modernizr/blob/master/feature-detects/storage/localstorage.js
CacheLibrary.prototype.browserSupportsLocalStorage = function () {
    var mod = 'modernizr';
    try {
        localStorage.setItem(mod, mod);
        localStorage.removeItem(mod);
        return true;
    } catch (e) {
        return false;
    }
};

//By default this is empty as some browsers doesn't support localStorage cache
CacheLibrary.prototype.setLocalStorageItem = function (item, value) {

};

//By default this is empty as some browsers doesn't support localStorage cache
CacheLibrary.prototype.removeLocalStorageItem = function (item) {

};

//By default this is empty as some browsers doesn't support localStorage cache
CacheLibrary.prototype.getLocalStorageItem = function (item) {
    return null;
};

CacheLibrary.prototype.setLocalStorageCache = function () {
    if (this.browserSupportsLocalStorage()) {
        //if browser is supporting local storage overrides the empty functions
        this.setLocalStorageItem = function (item, value) {
            localStorage.setItem(item, value);
        };
        this.removeLocalStorageItem = function (item) {
            localStorage.removeItem(item);
        };
        this.getLocalStorageItem = function (item) {
            return localStorage.getItem(item);
        };
    }
};

CacheLibrary = new CacheLibrary();
CacheLibrary.setLocalStorageCache();